package com.shipsy.ondemand.riderapp.framework.network.model.transactionhistory

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

/**
 * Created by Kalpesh Kundanani on 12/10/22
 */
typealias TransactionData = List<TransactionRecord>

@Serializable
data class TransactionRecord (
    @SerialName("settlement_request_id")
    val settlementRequestID: String? = null,

    @SerialName("total_amount")
    val totalAmount: Double? = null,

    @SerialName("request_details")
    val requestDetails: List<TransactionRequestDetail>? = null,

    @SerialName("payment_mode")
    val paymentMode: String? = null
)

@Serializable
data class TransactionRequestDetail (
    @SerialName("reference_number")
    val referenceNumber: String? = null,

    @SerialName("order_date")
    val orderDate: String? = null,

    val amount: Double? = null,

    @SerialName("order_number")
    val orderNumber: String? = null,

    @SerialName("credit_type")
    val creditType: String? = null
)
