package com.shipsy.ondemand.riderapp.framework.network.model.riderevent

import com.shipsy.ondemand.riderapp.framework.network.model.login.*
import kotlinx.serialization.Serializable

@Serializable
data class RiderEvent(
    val type: String,
    val reference_number_array: List<String>,
    val transaction_id: String,
    val timestamp: Long,
    val lat: Double,
    val lng: Double,
    val payment_details: List<PaymentDetails>?=null,
    val auto_swipe: Boolean = false,
    val discount: Discount? = null,
    val reason: UndeliveredReason? = null,
    val receiver_relation: RelationData? = null,
    val hu_details: List<HUDetail>? = null,
    val vehicle_number: String? = null,
    val skip_vehicle_scan_reason: String? = null,
    val pieces_status_detail: List<PieceDetails>? = null,
    val partial_delivery_reason: UndeliveredReason? = null
)

@Serializable
data class RiderStateRequest(val checkout: Boolean?,val events: List<RiderEvent>?)