package com.shipsy.ondemand.riderapp.framework.network.model.login

import kotlinx.serialization.Serializable

@Serializable
data class PickupConfig(
    val enable_picking_flow: Boolean = false,
    val scan_bags_barcode: Boolean = false, // not in use.
    val allow_scan: Boolean = false,
    val allow_manual_entry: Boolean = false,
    val allow_manual_pickup: Boolean = false,
    val allow_partial_order_pickup: Boolean = false,
    val reasons: PickupProcessReasonsList? = null,
    val failure_reason_required: Boolean = false,
    val failure_image_required: Boolean = false,
    val scan_timer_duration: Long = 0,
    val disable_pickup_failed: Boolean? = false
)

@Serializable
data class PickupProcessReasonsList(
    val scan_failed: ArrayList<String>,
    val manual_entry_failed: ArrayList<String>,
    val manual_pickup: ArrayList<String>,
    val not_manual_pickup: ArrayList<String>
)
