package com.shipsy.ondemand.riderapp.framework.network.model.login

import kotlinx.serialization.Serializable

@Serializable
data class OrderInstructions(
    var id: String? = null,
    var title: String? = null,
    var icon: String? = null,
    var instructions: ArrayList<String> = arrayListOf(),
    var background_color: String
) {
    fun getInstructionInFormat(): String {
        val stringBuilder = StringBuilder()
        for ((i, instruction) in instructions.withIndex()) {
            stringBuilder.append("${i + 1}. ")
                .append(instruction)
                .append("\n")
        }
        return stringBuilder.toString().dropLast(1)
    }
}
