package com.shipsy.ondemand.riderapp.framework.network.model.login

import kotlinx.serialization.Serializable

@Serializable
data class Location(
    var phone: String? = null,
    var alternate_phone: String? = null,
    var address_line_1: String? = null,
    var address_line_2: String? = null,
    var street_number: String? = null,
    var address_line_3: String? = null,
    var address_line_4: String? = null,
    var name: String? = null,
    var pincode: String? = null,
    var lat: Double? = 0.0,
    var lng: Double? = 0.0
) {
    val isLocationValid: Boolean
        get() = lat != null && lat != 0.0 && lng != null && lng != 0.0

    val customerCompleteAddress: String
        get() {
            val list = arrayListOf<String?>()
            list.add(street_number)
            list.add(address_line_1)
            list.add(address_line_2)
            list.add(address_line_3)
            list.add(address_line_4)
            list.add(pincode)
            return list.filter { !it.isNullOrBlank() }.joinToString(", ")
        }

}