package com.shipsy.ondemand.riderapp.framework.network.model.login

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.Transient

@Serializable
data class HUDetail(
    val label: String? = "",
    val hu_number: String? = ""
) {
    var status: String = ""

    @Transient
    var isScanned: Boolean = false

    @SerialName("failure_reason")
    var failureReason: String? = ""

    @SerialName("scan_type")
    var scanType: String? = ""

    var image: String? = ""

    @Transient
    var imageAsBytes: ByteArray? = null

    fun scanTypeScan() {
        scanType = TYPE_SCAN
    }

    fun scanTypeManual() {
        scanType = TYPE_MANUAL
    }

    fun setStatus(isSuccess: Boolean, isUndelivered: Boolean) {
        when (scanType) {
            TYPE_SCAN -> {
                status = if (isSuccess) {
                    STATUS_MANUAL
                } else {
                    STATUS_FAILURE
                }
            }
            TYPE_MANUAL -> {
                status = if (isSuccess) {
                    if (isUndelivered) {
                        STATUS_MANUAL
                    } else {
                        STATUS_SUCCESS
                    }
                } else {
                    STATUS_FAILURE
                }
            }
        }
    }

    fun isStatusManualOrSuccess(): Boolean = status == STATUS_SUCCESS || status == STATUS_MANUAL

    fun isScanFailed(): Boolean = scanType == TYPE_SCAN && status == STATUS_FAILURE

    fun isEnterManuallyFailed(): Boolean = scanType == TYPE_MANUAL && status == STATUS_FAILURE

    fun isSuccess(): Boolean = status == STATUS_SUCCESS

    fun isManual(): Boolean = status == STATUS_MANUAL

    fun isFailure(): Boolean = status == STATUS_FAILURE

    companion object {
        const val TYPE_SCAN = "scan"
        const val TYPE_MANUAL = "manual"
        const val STATUS_SUCCESS = "success"
        const val STATUS_MANUAL = "manual"
        const val STATUS_FAILURE = "failure"
    }
}
