package com.shipsy.ondemand.riderapp.framework.network.model.login

import com.shipsy.ondemand.riderapp.domain.const.OrderStatusType
import com.shipsy.ondemand.riderapp.domain.orderstatus.OrderType
import kotlinx.serialization.Serializable

@Serializable
data class CurrentOrder(
    val reference_number: String,
    val status: String,
    val task_type: String? = null,
    val is_cod: Boolean? = false,
    val cod_amount: Double?,
    val is_vip: Boolean? = false,
    val is_bulk: Boolean? = false,
    val notes: String?,
    val order_type: String?,
    val payment_details: List<PaymentDetails>?,
    val pieces_detail: List<PieceDetails>?,
    val order_number: String,
    val makeline_time: Long?,
    val final_amount: Double?,
    val order_promise_start_time_ondemand: Long? = 0,
    val location: Location?,
    var ondemand_delivery_promise_mins: Long? = 30,
    val otp: String?,
    var priority: Int?,
    val ondemand_discount: OnDemandDiscount?,
    val last_updated_at: Long?,
    val assign_time: Long?,
    val storage_location: String?,
    val hu_details: List<HUDetail>?,
    val order_instructions: List<String>?,
    val tip: Double?,
    val eligible_payout: Double?
) {

    val isRTOTask: Boolean
        get() = task_type == OrderType.RTO

    val isPickupTask: Boolean
        get() = task_type == OrderType.PICKUP

    val isDeliveryTask: Boolean
        get() = task_type == OrderType.DELIVERY

    val isPickupComplete: Boolean
        get() = status == OrderStatusType.PICKUP_COMPLETED

    val isReachedGate: Boolean
        get() = status == OrderStatusType.REACHED_GATE

    val isAssignedForDelivery: Boolean
        get() = status == OrderStatusType.ASSIGNED_FOR_DELIVERY

    val isPickupStarted: Boolean
        get() = status == OrderStatusType.PICKED_UP

    val hasHuDetails: Boolean
        get() = !hu_details.isNullOrEmpty()

    val isOrderGoingForPickup: Boolean
        get () = isPickupTask && isAssignedForDelivery

    //    fun isRtoOrder(): Boolean {
//        return taskType == RTO
//    }
//
//    fun isDeliveryOrder(): Boolean {
//        return taskType == DELIVERY
//    }
//
//    fun isPickupOrder(): Boolean {
//        return taskType == PICKUP
//    }
//
//    fun isOrderAssignedForDelivery(): Boolean {
//        return status == ASSIGNED_FOR_DELIVERY
//    }
//
//    fun isOrderGoingForDelivery(): Boolean {
//        return status == PICKED_UP
//    }
//
//    fun isOrderReachedGate(): Boolean {
//        return status == REACHED_GATE || status == RTO_REACHED_GATE
//    }
    val itemsInOrder: String
        get() {
            val builder = StringBuilder()
            for (piece in pieces_detail ?: listOf()) {
                builder.append("${piece.quantity} X ${piece.menu_description} \n")
            }
            return builder.toString()
        }
}
