package com.shipsy.ondemand.riderapp.framework.network.model.login

import com.shipsy.ondemand.riderapp.domain.const.*
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

/**
 * Created by Kalpesh Kundanani on 06/10/22
 */
@Serializable
data class CodReconPaymentMethod(
    @SerialName("id") val id: String?,
    @SerialName("label") val label: String?,
    @SerialName("allow_rider_withdraw") val allowRiderWithdraw: Boolean = false,
    @SerialName("show_upload_deposit_slip") val showUploadDepositSlip: Boolean = true,
    @SerialName("mandatory_deposit_slip") val mandatoryDepositSlip: Boolean = false,
    @SerialName("allow_manual_settlement") val allowManualSettlement: Boolean? = null,
) {

    @SerialName("is_enabled") var isEnabled : Boolean? = true
        get() = field ?: true
        set(value) {
            if(value != null)
                field = value
        }

    val isCash: Boolean
        get() = id.equals(OFFLINE) && isEnabled == true

    val isUpi: Boolean
        get() = id.equals(ONLINE) && isEnabled == true

    val isSpiceMoney: Boolean
        get() = id.equals(SPICE_MONEY) && isEnabled == true

    val isPaytm: Boolean
        get() = id.equals(PAYTM) && isEnabled == true

    val isAirtelMoney: Boolean
        get() = id.equals(AIRTEL) && isEnabled == true

    val isPayNearBy: Boolean
        get() = id.equals(PAY_NEARBY) && isEnabled == true

    val paymentType: String
        get() {
            return if (isUpi) {
                "upi"
            } else if (isPaytm) {
                "paytm"
            } else {
                "cash"
            }
        }


    val displayName: String
        get() {
            return when (id) {
                OFFLINE -> "Cash"
                ONLINE -> "UPI"
                SPICE_MONEY -> "Spice Money"
                PAYTM ->  "Paytm"
                AIRTEL -> "Airtel Money"
                PAY_NEARBY -> "Pay Near By"
                else -> id ?: "-"
            }
        }
}
