package com.shipsy.ondemand.riderapp.framework.network.model.login

import kotlinx.serialization.Serializable

@Serializable
data class AppUpdate(
    var update_type: String? = null,
    var message: String? = null,
    var latest_version_code: Int? = null,
    var min_supported_version_code: Int? = null,
    var app_link_side_load: String? = null,
    var app_link: String? = null,
    var allow_s3_update: Boolean? = null
) {
    val isSoftUpdate: Boolean
        get() = update_type?.equals("OPTIONAL", ignoreCase = true) == true

    val popupMessage: String
        get() = message ?: "Your app version is old. Please click on Update now to install a newer version."
}