package com.shipsy.ondemand.riderapp.framework.network.model.login

import com.shipsy.finance.models.network.FinanceScreenDisplayData
import com.shipsy.ondemand.riderapp.framework.data.orderhistory.DeliveryStateData
import kotlinx.serialization.Serializable

@Serializable
data class AppConfigurationData(
    var failure_reason_list: ArrayList<GenericIdName>? = null,
    var app_update: AppUpdate? = null,
//    var status_send_interval: Long = 0,
    var gps_sampling_interval: Long = 0,
    var create_event_file: Boolean = false,
    var event_file_interval: Long = 0,
//    var get_settings_interval: Long = 0,
    var ondemand_show_retry: Boolean = false,
    var ondemand_show_color_coding_for_order_sequence: Boolean = false,
    var show_rider_id_card: Boolean = false,
    var restrict_rider_checkout_in_assigned_state: Boolean = false,
    var verify_before_marking_pickup_completed: Boolean = false,
    var disable_file_upload: Boolean = false,
    var riderstate_polling_time_seconds: Long? = null,
    var cod_reconcilation_hubs: ArrayList<HubListData>? = null,
    var onduty: Boolean = false,
    var battery_based_intervals: ArrayList<BatteryInterval>? = null,
    var status_send_interval_min: Long = 0,
    var status_send_interval_max: Long = 0,
    var status_send_distance: Long = 0,
    var gps_cache_expiry: Long = 0,
    var update_firebase_coordinates: Boolean = false,
    var ondemand_back_to_store_config: OnDemandBackToStoreConfig? = null,
//    var ondemand_delivered_config: OnDemandBackToStoreConfig? = null,
//    var ondemand_reached_gate_config: OnDemandBackToStoreConfig? = null,
    var ondemand_show_performance: Boolean = false,
    var show_rider_payout: Boolean = false,
//    var ondemand_suspicious_undelivered: OnDemandBackToStoreConfig? = null,
    var geofence_config: HashMap<String, GeoConfigModel>? = null,
    var receiver_relation_list: ArrayList<RelationData>? = null,
    var enable_ondemand_custom_notification_sound: Boolean = false,
    var notification_sound_config: HashMap<String, SoundSettingModel>? = null,
    var allow_cash_edit: Boolean = false,
    var timezone: String? = null,
    var customer_care_phone: String? = null,
    var show_worker_credit_module: Boolean = false,
    var ondemand_enable_upi_payment: Boolean = false,
    var firebase_live_tracking: Boolean = false,
    var show_shifts_for_all_riders_ondemand: Boolean = false,
    var show_picked_up_in_delivery_flow: Boolean = false,
    var ondemand_event_disable_millis: ArrayList<EventDisableDuration>? = null,
    var suspicious_event_distance: Long = -1,
    var ondemand_check_in_distance: Long = 500,
    // Milliseconds after day start to reset user state, Default set to morning at 6
    var ondemand_reset_state_epoch: Long = (6 * 60 * 60 * 1000).toLong(),
    var tsg_discount_reasons: ArrayList<Reason>? = null,
    var call_log_status_list: ArrayList<String>? = null,
    var partial_delivery_reason_list: ArrayList<String>? = null,
    var default_tsg_min_duration: Int = 0,
    var default_tsg_max_duration: Int = 0,
    var late_discount_reasons: ArrayList<Reason>? = null,
    var default_late_discount: Long = 0,
    var default_late_min_duration: Long = 0,
    var default_late_max_duration: Long = 0,
    var show_ondemand_undelivered_tab: Boolean = false,
    var show_ondemand_helpdesk_notifs: Boolean = false,
    var currency_symbol: String? = null,
    var ondemand_enable_cod_file_upload: Boolean = false,
    var aarogya_setu_app_check: Boolean = false,
    var aarogya_setu_app_link: String? = null,
    var upi_payment_provider: String? = null,
    var upi_payment_expiry_time: Long? = null,
    var upi_payment_icon_url: String? = null,
    var do_not_restrict_shift_checkin: Boolean = false,
    var show_shifts_ondemand: Boolean = false,
    var show_rider_login_history: Boolean = false,
    var show_order_review_screen: Boolean = false,
    var enable_ondemand_paytm_qr_persistence: Boolean = false,
    var allow_call_log_in_rider_app: Boolean = false,
    var show_terms_and_condition_check_at_login: Boolean = false,
    var rider_terms_and_conditions_latest_version: String? = null,
    var rider_terms_and_conditions: String? = null,
    var ondemand_notification_sound: Int = 0,
    var show_rider_weekoffs: Boolean = false,
    var app_flow_config: ArrayList<AppFlowConfig>? = null,
    var enable_pickup_delivery: Boolean = false,
    var allow_otp_validation: Boolean = false,
    var child_hub_list: List<ChildHubModel>? = null,
    var allow_checkin_from_child_hubs: Boolean = false,
    var is_battery_usage_restricted: Boolean = true,
    var message_on_rider_eligible_cohort: String? = null,
    var message_on_rider_ineligible_cohort: String? = null,
    var cohort_change_message_pop_up: String? = null,
    var ondemand_vehicle_qrcode_scan: Boolean = false,
    var ALLOW_S3_SOFT_UPDATE: Boolean? = null,
    var shift_management: ShiftManagement? = null,
    val skip_vehicle_scan_timeout: String? = null,
    var ondemand_enable_card_payment: Boolean? = null,
    var hide_address_before_ofd: Boolean? = null,
    var skip_vehicle_scan_reason_list: ArrayList<VehicleScanReason>? = null,
    var order_instructions: ArrayList<OrderInstructions>? = null,
    var pl1: Boolean? = null,
    var pl2: ArrayList<Reason>? = null,
    val checkout_for_fake_gps: Boolean = false,
    val undelivered_validations: UndeliveredValidations? = null,
    var allow_delivery_otp_skip: Boolean = false,
    var allow_pickup_without_order_details: Boolean = false,
    var enable_card_transaction_id: Boolean = false,
    var ondemand_pickup_config: PickupConfig? = null,
    var allow_partial_delivery: Boolean? = null,
    val rider_app_icons_config: ArrayList<DeliveryStateData>? = null,
    val ondemand_delivery_config: DeliveryScanFlowConfig? = null,
    val cod_recon_payment_methods: List<CodReconPaymentMethod>? = null,
    val show_rider_payout_in_cod: Boolean = false,
    val use_order_level_details_for_settlement: Boolean = false,
    val restrict_raise_cod_in_riderapp: Boolean = false,
    val finance_screen_data_to_show: FinanceScreenDisplayData? = null,
    val firebase_database_url: String? = ""
)