package com.shipsy.ondemand.riderapp.framework.network.mapper

import com.shipsy.ondemand.riderapp.framework.network.model.BaseResponse
import com.shipsy.ondemand.riderapp.framework.network.model.OrganisationData
import com.shipsy.ondemand.riderapp.framework.network.model.login.LoginResponse
import com.shipsy.ondemand.riderapp.interactor.data.OrgLoginResponse

fun BaseResponse<OrganisationData>.mapOrgResponseToOrgOutput(): OrgLoginResponse {
    return OrgLoginResponse(
        id = data!!.organisation_id,
        name = data.organisation_name,
        displayName = data.ondemand_organisation_pretty_name ?: "",
        lightLogo = data.ondemand_light_logo_url ?: "",
        miniLogo = data.ondemand_mini_logo_url ?: "",
    )
}

fun BaseResponse<LoginResponse>.mapLoginResponseToLoginResponse(): LoginResponse {
    return this.data!!
}