package com.shipsy.ondemand.riderapp.framework.main.settings

import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.*
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.deliveryscan.IsManualDeliveryAllowedUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.deliveryscan.IsManualEntryAllowedDeliveryScanUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.deliveryscan.IsPartialOrderDeliveryAllowedUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.deliveryscan.IsScannerEnabledInDeliveryScanUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.navigationdrawer.ShowLoginHistoryNavUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.navigationdrawer.ShowWorkerCreditNavUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.pickupscan.IsManualEntryAllowedPickupScanUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.pickupscan.*
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.pickupscan.IsPickupWithoutOrderDetailsAllowedUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.orderdetail.GetDeliveryScreenDisableSlideDataUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.orderdetail.GetSwipeTextOrderDetailUseCase
import org.koin.core.component.KoinComponent
import org.koin.core.component.inject

class SettingsHelper : KoinComponent {
    val shouldFetchAppSettingsUseCase: ShouldFetchAppSettingsUseCase by inject()
    val syncAppSettingUseCase: SyncAppSettingUseCase by inject()
    val updateSettingTimeUseCase: UpdateSettingTimeUseCase by inject()
    val undeliveredReasonsFetchUseCase: UndeliveredReasonsFetchUseCase by inject()

    val isPudoFlowEnabledUseCase: IsPudoFlowEnabledUseCase by inject()
    val isPickingFlowEnabledUseCase: IsPickingFlowEnabledUseCase by inject()

    val checkAllowOTPValidationUseCase: CheckAllowOTPValidationUseCase by inject()
    val getSwipeTextOrderDetailUseCase: GetSwipeTextOrderDetailUseCase by inject()

    val isPartialOrderPickupAllowedUseCase: IsPartialOrderPickupAllowedUseCase by inject()
    val isPickupFailedDisabledUseCase: IsPickupFailedDisabledUseCase by inject()
    val isManualPickupAllowedUseCase: IsManualPickupAllowedUseCase by inject()
    val isScannerEnabledInPickupScanUseCase: IsScannerEnabledInPickupScanUseCase by inject()
    val isManualEntryAllowedPickupScanUseCase: IsManualEntryAllowedPickupScanUseCase by inject()
    val isPickupWithoutOrderDetailsAllowedUseCase: IsPickupWithoutOrderDetailsAllowedUseCase by inject()

    val isScannerEnabledInDeliveryScanUseCase: IsScannerEnabledInDeliveryScanUseCase by inject()
    val isManualEntryAllowedDeliveryScanUseCase: IsManualEntryAllowedDeliveryScanUseCase by inject()
    val isPartialOrderDeliveryAllowedUseCase: IsPartialOrderDeliveryAllowedUseCase by inject()
    val isManualDeliveryAllowedUseCase: IsManualDeliveryAllowedUseCase by inject()
    val getSwipeDisableTimeUseCase: GetSwipeDisableTimeUseCase by inject()
    val getDeliveryScreenDisableSlideDataUseCase: GetDeliveryScreenDisableSlideDataUseCase by inject()
    val checkUnDeliveredEnabledUseCase: CheckUnDeliveredEnabledUseCase by inject()
    val checkIfEnableCardPaymentUseCase: CheckIfEnableCardPaymentUseCase by inject()
    val shouldShowReasonToCallPopupUseCase: ShouldShowReasonToCallPopupUseCase by inject()
    val fetchCallReasonListUseCase: FetchCallReasonListUseCase by inject()
    val receiverRelationFetchUseCase: ReceiverRelationFetchUseCase by inject()

    val showLoginHistoryNavUseCase: ShowLoginHistoryNavUseCase by inject()
    val showWorkerCreditNavUseCase: ShowWorkerCreditNavUseCase by inject()
    val getAppUpdateUseCase: GetAppUpdateUseCase by inject()
    val getCohortChangeMessageUseCase: GetCohortChangeMessageUseCase by inject()
}