package com.shipsy.ondemand.riderapp.framework.main.settings

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.interactor.usecase.FirebaseAuthenticationUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.MixpanelEventHandlerUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.UpdateFirebaseAuthenticationUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.notification.SaveNotificationDataUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.sdk.*
import org.koin.core.component.KoinComponent
import org.koin.core.component.inject

class FirebaseSettingHelper : KoinComponent {
    val localStore: LocalStore by inject()
    val fetchFirebaseSettingHelper: FetchSdkFirebaseDataUseCase by inject()
    val fetchMasterDataUseCase: FetchMasterDataUseCase by inject()
    val firebaseAuthenticationUseCase: FirebaseAuthenticationUseCase by inject()
    val updateFirebaseAuthenticationUseCase: UpdateFirebaseAuthenticationUseCase by inject()
    val saveNotificationDataUseCase: SaveNotificationDataUseCase by inject()
    val setLocationTrackingActiveUseCase: SetLocationTrackingActiveUseCase by inject()
    val fetchIsLocationTrackingActiveUseCase: FetchIsLocationTrackingActiveUseCase by inject()
    val flushSdkRiderSavedPrefUseCase : FlushSdkRiderSavedPrefUseCase by inject()
    val mixpanelEventHandlerUseCase: MixpanelEventHandlerUseCase by inject()
}