package com.shipsy.ondemand.riderapp.framework.main

import com.shipsy.ondemand.riderapp.domain.usecase.FetchSavedAdsIdUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.notification.StopNotificationSoundUseCaseImpl
import com.shipsy.ondemand.riderapp.interactor.helper.UiRefreshNeeded
import com.shipsy.ondemand.riderapp.interactor.usecase.FetchSavedAdsIdUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.RiderStateUpdatedUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.SaveAdsIdUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.SideNavUserDetailUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.appupdate.CheckForAppUpdateUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.logout.LogoutUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.notification.PlayNotificationSoundUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.notification.StopNotificationSoundUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.riderstate.FetchTripReferenceNumberUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.riderstate.IsRiderCheckedIn
import com.shipsy.ondemand.riderapp.interactor.usecase.riderstate.RiderCurrentStateUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.riderstate.RiderStateHandlerUseCase
import org.koin.core.component.KoinComponent
import org.koin.core.component.inject

class MainHelper : KoinComponent {
    val sideNavUserDetailUseCase: SideNavUserDetailUseCase by inject()
    val riderStateHandlerUseCase: RiderStateHandlerUseCase by inject()
    val uiRefreshNeeded: UiRefreshNeeded by inject()
    val riderStateUpdatedUseCase: RiderStateUpdatedUseCase by inject()
    val isRiderCheckedIn: IsRiderCheckedIn by inject()
    val riderCurrentStateUseCase: RiderCurrentStateUseCase by inject()
    val logoutUseCase: LogoutUseCase by inject()
    val fetchTripReferenceNumberUseCase: FetchTripReferenceNumberUseCase by inject()
    val playNotificationSoundUseCase: PlayNotificationSoundUseCase by inject()
    val stopNotificationSoundUseCase: StopNotificationSoundUseCase by inject()
    val saveAdsIdUseCase: SaveAdsIdUseCase by inject()
    val fetchSavedAdsIdUseCase: FetchSavedAdsIdUseCase by inject()
    val checkForAppUpdateUseCase: CheckForAppUpdateUseCase by inject()
}