package com.shipsy.ondemand.riderapp.framework.main

import com.shipsy.ondemand.riderapp.interactor.usecase.MixpanelEventHandlerUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.sdk.FetchSdkAppSettingsUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.sdk.FetchSdkOrgIdUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.SideNavUserDetailUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.autoswipe.AutoSwipeUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.location.FetchSavedLocation
import com.shipsy.ondemand.riderapp.interactor.usecase.location.SaveLocationUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.notification.GetNotificationDataUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.sdk.FetchSdkHealthDataUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.sdk.FetchSdkWorkerDetailsUseCase
import org.koin.core.component.KoinComponent
import org.koin.core.component.inject

class LocationUseCaseHelper : KoinComponent {
    val fetchSavedLocation: FetchSavedLocation by inject()
    val saveLocationUseCase: SaveLocationUseCase by inject()
    val sideNavUserDetailUseCase : SideNavUserDetailUseCase by inject()
    val autoSwipeUseCase: AutoSwipeUseCase by inject()
    val fetchAppSettingsUseCase: FetchSdkAppSettingsUseCase by inject()
    val fetchSdkOrgIdUseCase: FetchSdkOrgIdUseCase by inject()
    val fetchSdkWorkerDetailsUseCase: FetchSdkWorkerDetailsUseCase by inject()
    val fetchSdkHealthDataUseCase: FetchSdkHealthDataUseCase by inject()
    val getNotificationDataUseCase: GetNotificationDataUseCase by inject()
    val mixpanelEventHandlerUseCase: MixpanelEventHandlerUseCase by inject()
}