package com.shipsy.ondemand.riderapp.framework.di

import com.shipsy.finance.domain.usecase.FetchFinanceScreenDataUseCaseImpl
import com.shipsy.finance.domain.usecase.appsettings.FinanceDisplayDataConfigUseCaseImpl
import com.shipsy.finance.domain.usecase.appsettings.ShowPerformanceScreenInFinanceConfigUseCaseImpl
import com.shipsy.finance.domain.usecase.appsettings.ShowRiderPayoutInFinanceConfigUseCaseImpl
import com.shipsy.finance.domain.usecase.appsettings.ShowWorkerCreditsInFinanceConfigUseCaseImpl
import com.shipsy.finance.domain.usecase.payoutscreen.FetchRiderPayoutUseCaseImpl
import com.shipsy.finance.interactors.usecase.appsettings.FinanceDisplayDataConfigUseCase
import com.shipsy.finance.interactors.usecase.appsettings.ShowPerformanceScreenInFinanceUseCaseConfig
import com.shipsy.finance.interactors.usecase.appsettings.ShowRiderPayoutInFinanceConfigUseCase
import com.shipsy.finance.interactors.usecase.appsettings.ShowWorkerCreditsInFinanceConfigUseCase
import com.shipsy.finance.interactors.usecase.financescreen.FetchFinanceScreenDataUseCase
import com.shipsy.finance.interactors.usecase.payoutscreen.FetchRiderPayoutUseCase
import com.shipsy.ondemand.core.interactor.HeaderProviderUseCase
import com.shipsy.ondemand.riderapp.domain.usecase.*
import com.shipsy.ondemand.riderapp.domain.usecase.appsettings.*
import com.shipsy.ondemand.riderapp.domain.usecase.appsettings.batteryinterval.UpdateBatteryIntervalUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.appsettings.deliveryScan.*
import com.shipsy.ondemand.riderapp.domain.usecase.appsettings.navigationdrawer.ShowLoginHistoryNavUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.appsettings.navigationdrawer.ShowWorkerCreditNavUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.appsettings.pickupscan.*
import com.shipsy.ondemand.riderapp.domain.usecase.appupdate.CheckForAppUpdateUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.autoswipe.AutoSwipeUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.autoswipe.CheckGoingForPickupAutoSwipeImpl
import com.shipsy.ondemand.riderapp.domain.usecase.autoswipe.GoingForPickupAutoSwipeUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.codsettlement.*
import com.shipsy.ondemand.riderapp.domain.usecase.eventhandler.*
import com.shipsy.ondemand.riderapp.domain.usecase.file.UploadFileUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.location.*
import com.shipsy.ondemand.riderapp.domain.usecase.firebase.SendFcmTokenToServerUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.firebase.UpdateFcmTokenUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.location.CalculateDistanceBetweenLocationUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.location.FetchSavedLocationImpl
import com.shipsy.ondemand.riderapp.domain.usecase.location.SaveLocationUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.loginhistory.FetchLoginHistoryUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.logout.ClearUserConfigUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.logout.EligibleForLogoutUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.logout.LogoutUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.notification.GetNotificationDataUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.notification.PlayNotificationSoundUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.notification.SaveNotificationDataUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.notification.StopNotificationSoundUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.orderdetail.*
import com.shipsy.ondemand.riderapp.domain.usecase.orderhistory.FetchDeliveryEventStatesUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.orderhistory.FetchOrderByDateUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.pickupprocess.FetchPickupProcessScreenToShowImpl
import com.shipsy.ondemand.riderapp.domain.usecase.pickupprocess.FetchPickupScanReasonDialogStateUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.pickupprocess.FetchPickupScanTimerDurationUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.riderstate.*
import com.shipsy.ondemand.riderapp.domain.usecase.sdk.*
import com.shipsy.ondemand.riderapp.domain.usecase.statemanagement.FetchOrderDetailUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.statemanagement.OrderDetailScreenUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.statemanagement.OrderListUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.statemanagement.OrderToShowForDetailUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.statusupdate.CallReasonStatusUpdateUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.transactionhistory.FetchApprovedRequestsUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.transactionhistory.FetchRaisedRequestsUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.transactionhistory.FetchRejectedRequestsUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.transactionhistory.WithdrawRequestUseCaseImpl
import com.shipsy.ondemand.riderapp.domain.usecase.worker.FetchWorkerIdUseCaseImpl
import com.shipsy.ondemand.riderapp.interactor.helper.UiRefreshNeeded
import com.shipsy.ondemand.riderapp.interactor.usecase.*
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.*
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.batterylevel.GetBatteryBasedIntervalObjectListUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.batterylevel.SaveBatteryBasedIntervalsUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.batterylevel.UpdateBatteryIntervalUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.deliveryscan.*
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.navigationdrawer.ShowLoginHistoryNavUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.navigationdrawer.ShowWorkerCreditNavUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.pickupscan.*
import com.shipsy.ondemand.riderapp.interactor.usecase.appupdate.CheckForAppUpdateUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.autoswipe.AutoSwipeUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.autoswipe.CheckGoingForPickupAutoSwipe
import com.shipsy.ondemand.riderapp.interactor.usecase.autoswipe.GoingForPickupAutoSwipeUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.codsettlement.*
import com.shipsy.ondemand.riderapp.interactor.usecase.eventhandler.*
import com.shipsy.ondemand.riderapp.interactor.usecase.file.UploadFileUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.firebase.SendFcmTokenToServerUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.firebase.UpdateFcmTokenUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.location.CalculateDistanceBetweenLocationUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.location.FetchSavedLocation
import com.shipsy.ondemand.riderapp.interactor.usecase.location.SaveLocationUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.loginhistory.FetchLoginHistoryUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.logout.ClearUserConfigUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.logout.EligibleForLogoutUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.logout.LogoutUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.notification.GetNotificationDataUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.notification.PlayNotificationSoundUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.notification.SaveNotificationDataUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.notification.StopNotificationSoundUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.orderdetail.*
import com.shipsy.ondemand.riderapp.interactor.usecase.orderhistory.FetchDeliveryEventStatesUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.orderhistory.FetchOrderByDateUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.pickupprocess.FetchPickupProcessScreenToShow
import com.shipsy.ondemand.riderapp.interactor.usecase.riderstate.*
import com.shipsy.ondemand.riderapp.interactor.usecase.sdk.*
import com.shipsy.ondemand.riderapp.interactor.usecase.statemanagement.FetchOrderDetailUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.statemanagement.OrderDetailScreenUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.statemanagement.OrderListUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.statemanagement.OrderToShowForDetailUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.statusupdate.CallReasonStatusUpdateUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.transactionhistory.FetchApprovedRequestsUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.transactionhistory.FetchRaisedRequestsUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.transactionhistory.FetchRejectedRequestsUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.transactionhistory.WithdrawRequestUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.worker.FetchWorkerIdUseCase
import io.shipsy.locationmodule.interactor.FirebaseLocationHandlerUseCase
import io.shipsy.locationmodule.interactor.usecase.FetchBatteryBasedConfigUseCase
import io.shipsy.locationmodule.interactor.usecase.IsLocationTrackingUseCase
import io.shipsy.locationmodule.interactor.usecase.UserDetailLocationUseCase
import org.koin.dsl.module

val useCaseModule = module {
    single { HeaderProviderUseCaseImpl(get(), get()) as HeaderProviderUseCase }
    factory { SplashNavigationUseCaseImpl(get()) as SplashNavigationUserCase }
    factory { OrganizationLoginUseCaseImpl(get(), get()) as OrganizationLoginUseCase }
    factory { FetchOrgDetailUseCaseImpl(get()) as FetchOrgDetailUseCase }
    factory { SdkLoginRiderUseCaseImpl(get(), get()) as SdkLoginRiderUseCase }
    factory { LoginRiderUseCaseImpl(get(), get(), get()) as LoginRiderUseCase }
    factory { SaveAppConfigUseCaseImpl(get(), get()) as SaveAppConfigUseCase }
    factory { SaveLoginDataUseCaseImpl(get(), get(), get(), get()) as SaveLoginDataUseCase }
    single { SideNavUserDetailUseCaseImpl(get()) as SideNavUserDetailUseCase }
    single { CheckInDetailUseCaseImpl(get()) as CheckInDetailUseCase }
    single { CheckInRiderUseCaseImpl(get(), get(), get(), get()) as CheckInRiderUseCase }
    single { ShouldUpdateRiderStateUseCaseImpl(get()) as ShouldUpdateRiderStateUseCase }
    single { UpdateRiderStatusUseCaseImpl(get(), get()) as UpdateRiderStatusUseCase }
    single { PostRiderStateUseCaseImpl(get(), get()) as PostRiderStateUseCase }
    single {
        UpdateRiderStateUseCaseImpl(
            get(),
            get(),
            get(),
            get(),
            get()
        ) as UpdateRiderStateUseCase
    }
    single { UpdateCurrentOrderUseCaseImpl(get(), get(), get()) as UpdateCurrentOrdersUseCase }
    single { ShouldUpdateLocalOrderUseCaseImpl(get()) as ShouldUpdateLocalOrderUseCase }
    single { ShouldFetchRiderStateUseCaseImpl(get()) as ShouldFetchRiderStateUseCase }
    single { FetchRiderStateUseCaseImpl(get(), get()) as FetchRiderStateUseCase }
    single {
        RiderStateHandlerUseCaseImpl(
            get(), get(), get(), get(), get()
        ) as RiderStateHandlerUseCase
    }
    single { OrderPriorityUseCaseImpl() as OrderPriorityUseCase }
    single { FetchOrderDetailUseCaseImpl(get()) as FetchOrderDetailUseCase }
    single {
        OrderDetailScreenUseCaseImpl(
            get(),
            get(),
            get(),
            get(),
            get()
        ) as OrderDetailScreenUseCase
    }
    single { OrderListUseCaseImpl(get()) as OrderListUseCase }
    single { OrderToShowForDetailUseCaseImpl(get(), get()) as OrderToShowForDetailUseCase }
    single { FindOrderDetailUseCaseImpl(get(), get()) as FindOrderDetailUseCase }
    single {
        RiderCurrentStateUseCaseImpl(
            get(),
            get(),
            get(),
            get(),
            get(),
            get(),
            get(),
        ) as RiderCurrentStateUseCase
    }
    single { UnDeliveredReasonsFetchUseCaseImpl(get()) as UndeliveredReasonsFetchUseCase }
    single { IsPudoFlowEnabledUseCaseImpl(get()) as IsPudoFlowEnabledUseCase }
    single { OrderDetailFetchUseCaseImpl(get()) as OrderDetailFetchUseCase }
    single { MultiOrderDetailFetchUseCaseImpl(get()) as MultiOrderDetailFetchUseCase }
    single { OrdersFetchUseCaseImpl(get()) as OrdersFetchUseCase }
    single { SaveLocationUseCaseImpl(get()) as SaveLocationUseCase }
    single { FetchSavedLocationImpl(get()) as FetchSavedLocation }
    factory { StartBikeEventUseCaseImpl(get(), get(), get()) as StartBikeEventUseCase }
    factory { ReachGateEventUseCaseImpl(get(), get(), get(), get()) as ReachGateEventUseCase }
    factory { RejectOrderEventUseCaseImpl(get(), get()) as RejectOrderEventUseCase }
    factory { AcceptOrderEventUseCaseImpl(get(), get()) as AcceptOrderEventUseCase }
    factory { GoingForPickupEventUseCaseImpl(get(), get()) as GoingForPickupEventUseCase }
    factory { RTODeliveredEventUseCaseImpl(get(), get()) as RTODeliveredEventUseCase }
    factory {
        PickupCompletedEventUseCaseImpl(
            get(),
            get(),
            get(),
            get(),
            get()
        ) as PickupCompletedEventUseCase
    }
    factory {
        PickingProcessStartedEventUseCaseImpl(
            get(),
            get(),
            get(),
            get()
        ) as PickingProcessStartedEventUseCase
    }
    single { EventSyncUseCaseImpl(get(), get(), get()) as EventSyncUseCase }
    single {
        LocalEventHandlingUseCaseImpl(
            get(),
            get(),
            get(),
            get(),
            get()
        ) as LocalEventHandlingUseCase
    }
    single { FetchRiderStateFromLocalImpl(get(), get()) as FetchRiderStateFromLocal }
    factory {
        DeliveredEventUseCaseImpl(
            get(),
            get(),
            get(),
            get(),
            get(),
            get(),
            get(),
            get(),
            get()
        ) as DeliveredEventUseCase
    }
    factory { ReturnToStoreEventUseCaseImpl(get(), get(), get()) as ReturnToStoreEventUseCase }
    factory {
        UnDeliveredEventUseCaseImpl(
            get(),
            get(),
            get(),
            get(),
            get()
        ) as UnDeliveredEventUseCase
    }
    factory {
        SuspiciousCheckUseCaseImpl(
            get(),
            get(),
            get(),
            get(),
            get()
        ) as SuspiciousCheckUseCase
    }
    factory { GetGeoConfigUseCaseImpl(get()) as GetGeoConfigUseCase }
    factory { CalculateDistanceBetweenLocationUseCaseImpl() as CalculateDistanceBetweenLocationUseCase }
    single { FetchHubDetailUseCaseImpl(get()) as FetchHubDetailUseCase }
    single { SaveHubDetailUseCaseImpl(get()) as SaveHubDetailUseCase }
    factory { CheckoutUseCaseImpl(get(), get(), get(), get(), get()) as CheckoutUseCase }
    factory { FetchWorkerIdUseCaseImpl(get()) as FetchWorkerIdUseCase }
    single { FirebaseAuthenticationUseCaseImpl(get()) as FirebaseAuthenticationUseCase }
    single { UpdateFirebaseAuthenticationUseCaseImpl(get()) as UpdateFirebaseAuthenticationUseCase }
    factory { FetchUpcomingOrdersUseCaseImpl(get(), get()) as FetchUpcomingOrdersUseCase }
    factory { EligibleForLogoutUseCaseImpl(get()) as EligibleForLogoutUseCase }
    factory { LogoutUseCaseImpl(get(), get(), get(), get()) as LogoutUseCase }
    factory { ClearUserConfigUseCaseImpl(get()) as ClearUserConfigUseCase }
    factory { UpdateFcmTokenUseCaseImpl(get()) as UpdateFcmTokenUseCase }
    factory { SendFcmTokenToServerUseCaseImpl(get(), get()) as SendFcmTokenToServerUseCase }

    single { SyncAppSettingUseCaseImpl(get(), get(), get()) as SyncAppSettingUseCase }
    single { SaveBatteryBasedIntervalsUseCaseImpl(get()) as SaveBatteryBasedIntervalsUseCase }

    single<GetBatteryBasedIntervalObjectListUseCase> { GetBatteryBasedIntervalObjectListUseCaseImpl(get(), get()) }
    single<UpdateBatteryIntervalUseCase> { UpdateBatteryIntervalUseCaseImpl(get(), get()) }


    single { ShouldFetchAppSettingsUseCaseImpl(get()) as ShouldFetchAppSettingsUseCase }
    single { RiderStateUpdatedUseCaseImpl(get()) }
    single { (get() as RiderStateUpdatedUseCaseImpl) as RiderStateUpdatedUseCase }
    single { (get() as RiderStateUpdatedUseCaseImpl) as UiRefreshNeeded }
    single { IsRiderCheckedInImpl(get()) as IsRiderCheckedIn }
    single { UpdateSettingTimeUseCaseImpl(get()) as UpdateSettingTimeUseCase }
//just for DB testing to be removed
    factory { OrderUpdationUseCaseImpl(get()) }
    factory { OrderFetchUseCaseImpl(get()) }

    single { FetchPickupProcessScreenToShowImpl() as FetchPickupProcessScreenToShow }

    single { FetchOrderByDateUseCaseImpl(get(), get()) as FetchOrderByDateUseCase }
    single { FetchDeliveryEventStatesUseCaseImpl(get()) as FetchDeliveryEventStatesUseCase }
    single { CheckIsDeliveryScanEnabledImpl(get()) as CheckIsDeliveryScanEnabled }
    single { CheckShowDeliveryScanImpl(get()) as CheckShowDeliveryScan }
    single { FetchDeliveryScanTimerDurationImpl(get()) as FetchDeliveryScanTimerDuration }

    single { FetchDeliveryScanReasonDialogStateUseCaseImpl(get()) as FetchDeliveryScanReasonDialogStateUseCase }
    single { FetchPickupScanReasonDialogStateUseCaseImpl(get()) as FetchPickupScanReasonDialogStateUseCase }
    single { UploadFileUseCaseImpl(get(), get()) as UploadFileUseCase }
    single { FetchOrderInstructionsUseCaseImpl(get(), get()) as FetchOrderInstructionsUseCase }
    single { GetOrderListItemClickActionImpl(get()) as GetOrderListItemClickAction }
    single { CheckOrderListItemIsClickableImpl(get()) as CheckOrderListItemIsClickable }
    single { FetchReferenceNumbersByOrderNumberUseCaseImpl(get()) as FetchReferenceNumbersByOrderNumberUseCase }
    single { IsPickingFlowEnabledUseCaseImpl(get()) as IsPickingFlowEnabledUseCase }
    single { CheckAllowOTPValidationUseCaseImpl(get()) as CheckAllowOTPValidationUseCase }
    single {
        CheckAllowDeliveryOTPValidationUseCaseImpl(
            get(),
            get()
        ) as CheckAllowDeliveryOTPValidationUseCase
    }
    single { FetchLoginHistoryUseCaseImpl(get()) as FetchLoginHistoryUseCase }
    single { FetchCodSettlementTasksUseCaseImpl(get()) as FetchCodSettlementTasksUseCase }
    single { FetchHubsUseCaseImpl(get()) as FetchHubsUseCase }
    single { FetchCODSettlementPaymentModesImpl(get()) as FetchCODSettlementPaymentModes }
    single { CheckShowPayoutInCODUseCaseImpl(get()) as CheckShowPayoutInCODUseCase }
    single {
        RaiseCODSettlementRequestUseCaseImpl(
            get(),
            get()
        ) as RaiseCODSettlementRequestUseCase
    }
    single { CheckUseOrderLevelDetailsForSettlementUseCaseImpl(get()) as CheckUseOrderLevelDetailsForSettlementUseCase }
    single { CheckRestrictRaiseCodUseCaseImpl(get()) as CheckRestrictRaiseCodUseCase }
    single { CreateQRCodeUseCaseImpl(get()) as CreateQRCodeUseCase }
    single { FetchApprovedRequestsUseCaseImpl(get()) as FetchApprovedRequestsUseCase }
    single { FetchRaisedRequestsUseCaseImpl(get()) as FetchRaisedRequestsUseCase }
    single { FetchRejectedRequestsUseCaseImpl(get()) as FetchRejectedRequestsUseCase }
    single { WithdrawRequestUseCaseImpl(get()) as WithdrawRequestUseCase }
    single { GetSwipeTextOrderDetailUseCaseImpl(get(), get()) as GetSwipeTextOrderDetailUseCase }
    single {
        OrderListSwipeEventUseCaseImpl(
            get(),
            get(),
            get(),
            get()
        ) as OrderListSwipeEventUseCase
    }
    single { FetchPickupScanTimerDurationUseCaseImpl(get()) as FetchPickupScanTimerDurationUseCase }
    single { PickupFailedEventUseCaseImpl(get(), get(), get()) as PickupFailedEventUseCase }
    single { IsPartialOrderPickupAllowedUseCaseImpl(get()) as IsPartialOrderPickupAllowedUseCase }
    single { IsPickupFailedDisabledUseCaseImpl(get()) as IsPickupFailedDisabledUseCase }
    single { IsManualPickupAllowedUseCaseImpl(get()) as IsManualPickupAllowedUseCase }
    single { IsScannerEnabledInPickupScanUseCaseImpl(get()) as IsScannerEnabledInPickupScanUseCase }
    single { IsManualEntryAllowedPickupScanUseCaseImpl(get()) as IsManualEntryAllowedPickupScanUseCase }
    single { IsPickupWithoutOrderDetailsAllowedUseCaseImpl(get()) as IsPickupWithoutOrderDetailsAllowedUseCase }
    single {
        CheckPickupSwipeEnabledWithoutHuUseCaseImpl(
            get(),
            get(),
            get(),
            get(),
            get()
        ) as CheckPickupSwipeEnabledWithoutHuUseCase
    }
    single { IsScannerEnabledInDeliveryScanUseCaseImpl(get()) as IsScannerEnabledInDeliveryScanUseCase }
    single { IsPartialOrderDeliveryAllowedUseCaseImpl(get()) as IsPartialOrderDeliveryAllowedUseCase }
    single { IsManualEntryAllowedDeliveryScanUseCaseImpl(get()) as IsManualEntryAllowedDeliveryScanUseCase }
    single { IsManualDeliveryAllowedUseCaseImpl(get()) as IsManualDeliveryAllowedUseCase }
    single { MarkLogoutBecauseUnauthorisedUseCaseImpl(get()) as MarkLogoutBecauseUnauthorisedUseCase }
    single { GetLoginScreenStateUseCaseImpl(get()) as GetLoginScreenStateUseCase }
    single { SaveUserCredentialsUseCaseImpl(get()) as SaveUserCredentialsUseCase }
    single {
        AutoSwipeUseCaseImpl(
            get(),
            get(),
            get(),
            get(),
            get(),
            get(),
            get(),
            get(),
            get(),
            get(),
            get()
        ) as AutoSwipeUseCase
    }
    single {
        GoingForPickupAutoSwipeUseCaseImpl(get(), get(), get()) as GoingForPickupAutoSwipeUseCase
    }
    single {
        CheckGoingForPickupAutoSwipeImpl(get(), get(), get(), get()) as CheckGoingForPickupAutoSwipe
    }
    single { GetSwipeDisableTimeUseCaseImpl(get()) as GetSwipeDisableTimeUseCase }
    single { RecordReachGateTimeUseCaseImpl(get()) as RecordReachGateTimeUseCase }
    single { GetReachGateTimeUseCaseImpl(get()) as GetReachGateTimeUseCase }
    single { GetDeliveryTimeUseCaseImpl(get()) as GetDeliveryTimeUseCase }
    single {
        GetDeliveryScreenDisableSlideDataUseCaseImpl(
            get(),
            get()
        ) as GetDeliveryScreenDisableSlideDataUseCase
    }
    single {
        GetBackToStoreDisableTimerUseCaseImpl(
            get(),
            get()
        ) as GetBackToStoreDisableTimerUseCase
    }
    single { RecordDeliveryTimeUseCaseImpl(get()) as RecordDeliveryTimeUseCase }
    single { ShowPickedUpInDeliveryInFlowUseCaseImpl(get()) as ShowPickedUpInDeliveryInFlowUseCase }
    single { CheckUnDeliveredEnabledUseCaseImpl(get()) as CheckUnDeliveredEnabledUseCase }
    single { CheckIfEnableCardPaymentUseCaseImpl(get()) as CheckIfEnableCardPaymentUseCase }
    single { FetchTripReferenceNumberUseCaseImpl(get()) as FetchTripReferenceNumberUseCase }
    single { FetchGpsSamplingIntervalUseCaseImpl(get()) as FetchGpsSamplingIntervalUseCase }
    single { FetchMasterDataUseCaseImpl(get(), get()) as FetchMasterDataUseCase }
    single { FetchSdkFirebaseDataUseCaseImpl(get()) as FetchSdkFirebaseDataUseCase }
    single { FetchSdkWorkerDetailsUseCaseImpl(get()) as FetchSdkWorkerDetailsUseCase }
    single { FetchSdkOrgIdUseCaseImpl(get()) as FetchSdkOrgIdUseCase }
    single { FetchSdkAppSettingsUseCaseImpl(get()) as FetchSdkAppSettingsUseCase }
    single { FetchSdkHealthDataUseCaseImpl(get(), get()) as FetchSdkHealthDataUseCase }
    single { FetchIsLocationTrackingActiveUseCaseImpl(get()) as FetchIsLocationTrackingActiveUseCase }
    single { SetLocationTrackingActiveUseCaseImpl(get()) as SetLocationTrackingActiveUseCase }
    single { SaveNotificationDataUseCaseImpl(get()) as SaveNotificationDataUseCase }
    single { GetNotificationDataUseCaseImpl(get()) as GetNotificationDataUseCase }
    single { ShouldShowReasonToCallPopupUseCaseImpl(get()) as ShouldShowReasonToCallPopupUseCase }
    single { FetchCallReasonListUseCaseImpl(get()) as FetchCallReasonListUseCase }
    single { CallReasonStatusUpdateUseCaseImpl(get()) as CallReasonStatusUpdateUseCase }
    single { ReceiverRelationFetchUseCaseImpl(get()) as ReceiverRelationFetchUseCase }
    single { IsReceiverRelationEnabledUseCaseImpl(get()) as IsReceiverRelationEnabledUseCase }
    single { ShowLoginHistoryNavUseCaseImpl(get()) as ShowLoginHistoryNavUseCase }
    single { ShowWorkerCreditNavUseCaseImpl(get()) as ShowWorkerCreditNavUseCase }
    single { PlayNotificationSoundUseCaseImpl(get()) as PlayNotificationSoundUseCase }
    single { StopNotificationSoundUseCaseImpl() as StopNotificationSoundUseCase }
    single { GetAppUpdateUseCaseImpl(get()) as GetAppUpdateUseCase }
    single { SaveAdsIdUseCaseImpl(get()) as SaveAdsIdUseCase }
    single { FetchSavedAdsIdUseCaseImpl(get()) as FetchSavedAdsIdUseCase }
    single { GetCohortChangeMessageUseCaseImpl(get()) as GetCohortChangeMessageUseCase }
    single { RemoveOrderUseCaseImpl(get(), get()) as RemoveOrderUseCase }
    single { CheckForAppUpdateUseCaseImpl(get(), get()) as CheckForAppUpdateUseCase }
    single { CheckGeofenceForCallingUseCaseImpl(get()) as CheckGeofenceForCallingUseCase }

    // Finance module related use-cases
    single { FetchFinanceScreenDataUseCaseImpl(get()) as FetchFinanceScreenDataUseCase }
    single { FetchRiderPayoutUseCaseImpl(get()) as FetchRiderPayoutUseCase }
    single { FinanceDisplayDataConfigUseCaseImpl(get()) as FinanceDisplayDataConfigUseCase }
    single { ShowPerformanceScreenInFinanceConfigUseCaseImpl(get()) as ShowPerformanceScreenInFinanceUseCaseConfig }
    single { ShowWorkerCreditsInFinanceConfigUseCaseImpl(get()) as ShowWorkerCreditsInFinanceConfigUseCase }
    single { ShowRiderPayoutInFinanceConfigUseCaseImpl(get()) as ShowRiderPayoutInFinanceConfigUseCase }

    //sdk
    single { FlushSdkRiderSavedPrefUseCaseImpl(get()) as FlushSdkRiderSavedPrefUseCase }

    single<UserDetailLocationUseCase> { UserDetailLocationUseCaseImpl(get()) }
    single<FetchBatteryBasedConfigUseCase> { FetchBatteryBasedConfigUseCaseImpl(get()) }
    single<IsLocationTrackingUseCase> { IsLocationTrackingUseCaseImpl() }
    single<EnableLocationTrackingV2UseCase> { EnableLocationTrackingV2UseCaseImpl(get()) }

}
