package com.shipsy.ondemand.riderapp.framework.di

import com.shipsy.finance.domain.repository.FinanceModuleRepositoryImpl
import com.shipsy.finance.interactors.repository.FinanceModuleRepository
import com.shipsy.ondemand.riderapp.domain.repository.*
import com.shipsy.ondemand.riderapp.interactor.repository.*
import org.koin.dsl.module

val repoModule = module {
    single { OrgLoginRepoImpl(get()) as OrgRepository }
    single { RiderLoginRepoImpl(get(), get()) as RiderLoginRepository }
    single { CheckInRepositoryImpl(get()) as CheckInRepository }
    single { FetchRiderStateRepositoryImpl(get()) as FetchRiderStateRepository }
    single { PostRiderEventRepositoryImpl(get()) as PostRiderEventRepository }
    single { CheckoutRepositoryImpl(get()) as CheckoutRepository }
    single { FetchUpcomingOrdersRepositoryImpl(get()) as FetchUpcomingOrdersRepository }
    single { LogoutRepositoryImpl(get()) as LogoutRepository }
    single { UpdateFcmTokenRepositoryImpl(get()) as UpdateFcmTokenRepository }
    single { HistoryRepositoryImpl(get()) as HistoryRepository }
    single { FetchAppSettingsRepositoryImpl(get()) as FetchAppSettingsRepository }
    single { FetchUrlForStorageRepositoryImpl(get()) as FetchUrlForStorageRepository }
    single { UploadFileRepositoryImpl(get()) as UploadFileRepository }
    single { CODSettlementRepositoryImpl(get()) as CODSettlementRepository }
    single { SDKRepositoryImpl(get()) as SDKRepository }
    single { StatusUpdateRepositoryImpl(get()) as StatusUpdateRepository }
    single { AppUpdateRepositoryImpl(get()) as AppUpdateRepository }
    single { FinanceModuleRepositoryImpl(get()) as FinanceModuleRepository }
}