package com.shipsy.ondemand.riderapp.framework.di

import com.shipsy.ondemand.core.framework.network.getClient
import com.shipsy.ondemand.core.interactor.RetryEndPoints
import com.shipsy.ondemand.riderapp.domain.usecase.RetryEndPointsImpl
import com.shipsy.ondemand.riderapp.framework.network.NetworkClientImpl
import com.shipsy.ondemand.riderapp.interactor.NetworkClient
import org.koin.dsl.module

val networkModule = module {
    single<RetryEndPoints> { RetryEndPointsImpl() }
    single {
        getClient(
            get(),
            get(),
            get()
        )
    }
    single<NetworkClient> {
        NetworkClientImpl(
            get()
        )
    }
}