package com.shipsy.ondemand.riderapp.framework.di

import com.shipsy.ondemand.core.framework.di.localStoreModule
import com.shipsy.ondemand.core.interactor.BaseUrlUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.HeaderNativeUseCase
import org.koin.core.context.startKoin
import org.koin.core.module.Module
import org.koin.dsl.module

fun initKoin(nativeModule: NativeModule) {
    startKoin {
        modules(moduleList(listOf(nativeUseCase(nativeModule))))
    }
}

fun nativeUseCase(nativeModule: NativeModule): Module {
    val module = module {
        single { nativeModule.baseUrlUseCase }
        single { nativeModule.headerNativeUseCase }
        single { nativeModule.analyticsNativeUseCase }
        single { nativeModule.setFirebaseEventsUserProperties }
        single { nativeModule.firebaseCrashlyticsUseCase }
    }
    return module
}


fun moduleList(nativeModule: List<Module> = listOf()): List<Module> {
    val moduleList =
        mutableListOf(localStoreModule, useCaseModule, networkModule, databaseModule, repoModule, mixpanelAnalyticsModule)
    moduleList.addAll(nativeModule)
    return moduleList
}