package com.shipsy.ondemand.riderapp.framework.data.sdk

import com.shipsy.ondemand.riderapp.domain.const.DEFAULT_FIREBASE_PING_INTERVAL
import com.shipsy.ondemand.riderapp.domain.const.DEFAULT_SDK_HEALTH_CHECK_API_INTERVAL
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

/**
 * Created by Kalpesh Kundanani on 26/09/22
 */
@Serializable
data class SdkAppSettings(
    @SerialName("sdk_health_check_api_interval") val sdkHealthCheckAPIInterval: Long = DEFAULT_SDK_HEALTH_CHECK_API_INTERVAL,
    @SerialName("update_firebase_coordinates") val updateFirebaseCoordinates: Boolean = false,
    @SerialName("firebase_ping_interval") val firebasePingInterval: Long = DEFAULT_FIREBASE_PING_INTERVAL,
    @SerialName("mixpanel_project_token") val mixpanelProjectToken: String? = null
)
