package com.shipsy.ondemand.riderapp.framework.data.sdk

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

/**
 * Created by Kalpesh Kundanani on 26/09/22
 */
@Serializable
data class SDKMasterDataFetchResponse(
    @SerialName("organisation_id") val organisationID: String? = null,
    @SerialName("firebase_application_id") val firebaseApplicationID: String? = null,
    @SerialName("firebase_database_url") val firebaseDatabaseURL: String? = null,
    @SerialName("firebase_api_key") val firebaseAPIKey: String? = null,
    @SerialName("firebase_project_id") val firebaseProjectID: String? = null,
    @SerialName("worker_details") val workerDetails: SdkWorkerDetails? = null,
    @SerialName("app_settings") var appSettings: SdkAppSettings? = null
)

@Serializable
data class SdkWorkerDetails(
    @SerialName("worker_code") val workerCode: String? = null,
    @SerialName("hub_code") val hubCode: String? = null,
    @SerialName("worker_id") val workerId: String? = null,
    @SerialName("firebase_access_token") val firebaseAccessToken: String? = null
)

@Serializable
data class SdkFirebaseData(
    @SerialName("firebase_application_id") val firebaseApplicationID: String? = null,
    @SerialName("firebase_database_url") val firebaseDatabaseURL: String? = null,
    @SerialName("firebase_api_key") val firebaseAPIKey: String? = null,
    @SerialName("firebase_project_id") val firebaseProjectID: String? = null,
)
