package com.shipsy.ondemand.riderapp.framework.data.orderhistory

import com.shipsy.ondemand.core.framework.datetime.DateTime
import kotlinx.serialization.Serializable

@Serializable
class DominoEventModel(
    val type: String? = null,
    val reason: String? = null,
    val event_time: String? = null,
) {
    val eventTimeAsLong: Long
        get() {
            return try {
                event_time!!.toLong()
            } catch (e: Exception) {
                0
            }
        }

    val formattedEventTime: String
        get() {
            return try {
                DateTime.format(event_time!!.toLong(), "hh:mm aa")
            } catch (e: Exception) {
                ""
            }
        }
}
