package com.shipsy.ondemand.riderapp.framework.data.orderhistory

import com.shipsy.ondemand.riderapp.framework.data.AlternateContact
import com.shipsy.ondemand.riderapp.framework.data.PieceObject
import com.shipsy.ondemand.riderapp.framework.network.model.login.Location
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

/**
 * Created by Kalpesh Kundanani on 22/08/22
 */
@Serializable
data class Consignment(
    var reference_number: String,
    val cod_amount: Double? = null,
    val is_cod: Boolean? = false,
    val location: Location? = null,
    val task_type: String? = null,
    val start_time: String? = null,
    val completion_time: Long? = null,
    val selection_time: Long? = null,
    val service_type_id: String? = null,
    val service_type_name: String? = null,
    val task_id: String? = null,
    val end_time: String? = null,
    val drs_number: String? = null,
    val currency_string: String? = null,
    val taskIsChecked: Boolean? = false,
    val scan_time: String? = null,
    val signaturePhotoPath: String? = null,
    val photoPath: String? = null,
    val status: String? = null,
    val priority: Int? = null,
    val receiverName: String? = null,
    val receiverRelation: String? = null,
    val text_color: String? = null,
    val bg_color: String? = null,
    val is_retained: Boolean? = null,
    val attempt_count: String? = null,
    val transaction_id: String? = null,
    val cod_collection_mode: String? = null,
    val isSelfAdded: Boolean? = false,
    val signature_not_taken: Boolean? = true,
    val poc_not_taken: Boolean? = true,
    val kyc_image_not_taken: Boolean? = true,
    val riderId: String? = null,
    val accessToken: String? = null,
    val customer_id: String? = null,
    val product_type_id: String? = null,
    val kyc_photo_path: String? = null,
    val config_hash: String? = null,
    val task_priority: String? = null,
    val delivery_time_slot: String? = null,
    val is_rescheduled: Boolean? = false,
    val alternate_receiver_details: AlternateContact? = null,
    val cod_favor_of: String? = null,
    val barcode: String? = null,
    val customer_name: String? = null,
    val makeline_time: Long? = 0,
    val order_time: String? = null,
    val final_amount: Double? = null,
    val rider_score: String? = null,
    val is_vip: Boolean? = false,
    val order_promise_start_time_ondemand: Long? = 0,
    val failure_reason: String? = null,
    val failure_reason_id: String? = null,
    val discount_type: String? = null,
    val discount_amount: String? = null,
    val tip: Double? = null,
    val eligible_payout: Double? = null,
    val payment_details: ArrayList<DominoPaymentModel>? = null,
    var event_details: ArrayList<DominoEventModel?>? = null,
    val isLastOrder: Boolean? = false,
    val pieces_detail: ArrayList<PieceObject>? = null,
    val special_instruction: String? = null,
    val order_number: String? = null,
    val hub_name: String? = null,
    val hub_code: String? = null,
    @SerialName("child_order_number") val childOrderNumber: String? = null,
    @SerialName("order_tags") val orderTags: List<String>? = null
) {
    val orderTimeAsLong: Long
        get() {
            return try {
                order_time!!.toLong()
            } catch (e: Exception) {
                0
            }
        }

    val isCanceled: Boolean
        get() = status.equals("archived") || status.equals("cancelled")
}
