package com.shipsy.ondemand.riderapp.framework.data.oderdata

import com.shipsy.ondemand.riderapp.domain.const.OrderStatusType
import com.shipsy.ondemand.riderapp.domain.orderstatus.OrderType
import com.shipsy.ondemand.riderapp.framework.network.model.login.CurrentOrder
import com.shipsy.ondemand.riderapp.framework.network.model.login.HUDetail
import com.shipsy.ondemand.riderapp.framework.network.model.login.PieceDetails

data class OrderData(
    val referenceNumber: String? = null,
    val orderNumber: String? = "",
    val customerName: String? = "",
    val phoneNumber: String? = "",
    val address: String? = "",
    val lat: Double? = 0.0,
    val lng: Double? = 0.0,
    val amount: Double? = 0.0,
    val amountCollected: Double? = 0.0,
    val payMode: String? = "",
    val items: String? = "",
    val instruction: String? = "",
    val taskType: String? = "",
    val ondemandDeliveryPromiseMins: Long? = 0,
    val orderPromiseStartTimeOndemand: Long? = 0,
    val makelineTime: Long? = 0,
    val isVip: Boolean? = false,
    val status: String? = null,
    val huDetails: List<HUDetail>? = null,
    val storageLocation: String? = null,
    val piecesDetail: List<PieceDetails>? = null,
    val orderInstructionIds: List<String?>?,
    val otp: String?,
    val assign_time: Long?,
) {
    fun getMinutesLeftToDeliver(currentTime: Long): Long {
        val deliveryPromiseTime: Long = (ondemandDeliveryPromiseMins ?: 0) * 60 * 1000
        val orderTime = orderPromiseStartTimeOndemand ?: 0
        return (deliveryPromiseTime - (currentTime - orderTime))/ 60000
    }

    val isRTOTask: Boolean
        get() = taskType == OrderType.RTO

    val isPickupTask: Boolean
        get() = taskType == OrderType.PICKUP

    val isDeliveryTask: Boolean
        get() = taskType == OrderType.DELIVERY

    val isPickupComplete: Boolean
        get() = status == OrderStatusType.PICKUP_COMPLETED

    val isReachedGate: Boolean
        get() = status == OrderStatusType.REACHED_GATE

    val isAssignedForDelivery: Boolean
        get() = status == OrderStatusType.ASSIGNED_FOR_DELIVERY

    val isPickupStarted: Boolean
        get() = status == OrderStatusType.PICKED_UP

    val isPickupProcessStarted: Boolean
        get() = status == OrderStatusType.PICKUP_PROCESS_STARTED

    val hasHuDetails: Boolean
        get() = !huDetails.isNullOrEmpty()

    companion object {
        fun fromCurrentOrder(currentOrder: CurrentOrder?): OrderData = OrderData(
            referenceNumber = currentOrder?.reference_number,
            orderNumber = currentOrder?.order_number,
            customerName = currentOrder?.location?.name,
            phoneNumber = currentOrder?.location?.phone,
            address = currentOrder?.location?.customerCompleteAddress,
            lat = currentOrder?.location?.lat,
            lng = currentOrder?.location?.lng,
            amount = currentOrder?.final_amount,
            amountCollected = currentOrder?.cod_amount,
            payMode = currentOrder?.payment_details?.first()?.cod_collection_mode,
            items = currentOrder?.itemsInOrder,
            instruction = currentOrder?.notes,
            taskType = currentOrder?.task_type,
            ondemandDeliveryPromiseMins = currentOrder?.ondemand_delivery_promise_mins,
            orderPromiseStartTimeOndemand = currentOrder?.order_promise_start_time_ondemand,
            makelineTime = currentOrder?.makeline_time,
            isVip = currentOrder?.is_vip,
            status = currentOrder?.status,
            huDetails = currentOrder?.hu_details,
            storageLocation = currentOrder?.storage_location,
            piecesDetail = currentOrder?.pieces_detail,
            orderInstructionIds = currentOrder?.order_instructions,
            otp = currentOrder?.otp,
            assign_time = currentOrder?.assign_time
        )
    }
}
