package com.shipsy.ondemand.riderapp.framework.data.codsettlement

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
data class SettlementData(
    @SerialName("worker_credits") val workerCredits: String = "",
    @SerialName("worker_payout") val workerPayout: Double = 0.0,
    @SerialName("data") val data: List<CashSettlementData?>?,
    @SerialName("next_page_exist") val nextPageExist: Boolean = false
)

@Serializable
data class CashSettlementData(
    @SerialName("settlement_request_id") val requestId: String? = "",
    @SerialName("amount_paid") val amountPaid: String? = null,
    @SerialName("total_amount") val totalAmount: Double? = null,
    @SerialName("worker_credit_id") var workerCreditId: String,
    @SerialName("reference_number") var referenceNumber: String? = "",
    @SerialName("order_number") val orderNumber: String,
    @SerialName("hub_code") val hubCode: String? = "",
    @SerialName("amount") val codAmount: Double? = null,
    @SerialName("payment_mode") val paymentMode: String? = null,
    @SerialName("order_date") val orderDate: String? = null,
    @SerialName("created_at") val createdAt: String? = null,
    @SerialName("is_petty_cash") val isPettyCash: Boolean = false,
    @SerialName("is_checked") var isChecked: Boolean = false,
    @SerialName("deposit_slip") val depositSlip: String? = null,
    @SerialName("cod_transaction_id") val transactionID: String? = null,
    @SerialName("request_details") val requestDetails: List<RequestDetail>? = null,
    @SerialName("merchant_name") val merchantName: String? = null
) {
    val amount: Double
        get() = codAmount ?: totalAmount ?: 0.0
    var isWithdrawChecked: Boolean = false
}

@Serializable
data class RequestDetail(
    @SerialName("order_id") val orderID: String? = null,
    @SerialName("reference_number") val referenceNumber: String? = null,
    @SerialName("order_date") val orderDate: String? = null,
    @SerialName("order_number") val orderNumber: String? = null,
    @SerialName("amount") val amount: Float? = null,
    @SerialName("credit_type") val creditType: String = "",
    @SerialName("is_petty_cash") val isPettyCash: Boolean = false,
    @SerialName("is_payout") val isPayout: Boolean = false
)

