package com.shipsy.ondemand.riderapp.framework.data.codsettlement
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
data class CashSettlementRequest(
    @SerialName("worker_credit_id") val workerCreditId: String = "",
    @SerialName("reference_number") val referenceNumber: String = "",
    @SerialName("hub_code") val hubCode: String = "",
    @SerialName("deposit_slip") val depositSlipS3UrlLink: String? = null,
    @SerialName("order_number") val orderNumber: String? = "",
    @SerialName("amount") val amount: Double? = 0.0,
    @SerialName("bulk_request_id") val cashBulkId: String? = null,
    @SerialName("payment_mode") val paymentMode: String? = null
)

@Serializable
data class TransactionSettlementRequest(
    @SerialName("transaction_id") val transactionId: String,
    @SerialName("payment_status") val paymentStatus: String,
    @SerialName("request_list") val requestList: ArrayList<CashSettlementRequest>
)
