package com.shipsy.ondemand.riderapp.framework.data

import com.shipsy.ondemand.riderapp.framework.data.oderdata.OrderData

sealed class OrderDetailStatus(
    val order: OrderData,
    val backAllowed: Boolean
) {
    data class AcceptScreen(
        val orderData: OrderData,
        val isBackAllowed: Boolean = false
    ) : OrderDetailStatus(orderData, isBackAllowed)

    data class ReachGateScreen(
        val orderData: OrderData,
        val isBackAllowed: Boolean = false
    ) : OrderDetailStatus(orderData, isBackAllowed)

    data class DeliveryScreen(
        val orderData: OrderData,
        val isBackAllowed: Boolean = false
    ) : OrderDetailStatus(orderData, isBackAllowed)

    data class ReviewScreen(
        val orderData: OrderData,
        val isBackAllowed: Boolean = false
    ) : OrderDetailStatus(orderData, isBackAllowed)

    data class GoingForPickup(
        val orderData: OrderData,
        val isBackAllowed: Boolean = false
    ) : OrderDetailStatus(orderData, isBackAllowed)

    data class PickingUpStarted(
        val orderData: OrderData,
        val isBackAllowed: Boolean = false
    ) : OrderDetailStatus(orderData, isBackAllowed)

    data class CompletePickup(
        val orderData: OrderData,
        val isBackAllowed: Boolean = false
    ) : OrderDetailStatus(orderData, isBackAllowed)
}
