package com.shipsy.ondemand.riderapp.framework.data

data class NavigationMenuItem(
    val id: NavigationItem,
    val name: String,
    val image: String
)

sealed class NavigationItem {
    data class Home(val riderStatusState: RiderStatusState) : NavigationItem()
    object OrderHistory : NavigationItem()
    object LoginHistory : NavigationItem()
    object CODSettlement : NavigationItem()
    object TransactionHistory : NavigationItem()
    object ForceRefresh : NavigationItem()
    object Logout : NavigationItem()
}