package com.shipsy.ondemand.riderapp.framework.data

sealed class CheckedInStatus {
    data class EligibleForOrder(
        val workerStatus: WorkerStatus,
        val screen:InStoreScreen
    ) :
        CheckedInStatus()

    data class OutForDeliver(
        val workerStatus: WorkerStatus,
        val screen: OutForDeliveryScreen
    ) : CheckedInStatus()

    data class ReturningToStore(
        val orderReferenceNumber: List<String>? = null
    ) : CheckedInStatus()

    data class OrderDetail(val orderDetailStatus: OrderDetailStatus, val referenceNumber: String) :
        CheckedInStatus()

    object OnBreak : CheckedInStatus()
    object WaitingForSlot : CheckedInStatus()
}
