package com.shipsy.ondemand.riderapp.domain.usecase.transactionhistory

import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.core.framework.network.getResult
import com.shipsy.ondemand.riderapp.framework.network.model.BaseResponse
import com.shipsy.ondemand.riderapp.framework.network.model.WithdrawRequestModel
import com.shipsy.ondemand.riderapp.interactor.repository.HistoryRepository
import com.shipsy.ondemand.riderapp.interactor.usecase.transactionhistory.WithdrawRequestUseCase

/**
 * Created by Kalpesh Kundanani on 15/10/22
 */
class WithdrawRequestUseCaseImpl(
    val repo: HistoryRepository
) : WithdrawRequestUseCase {
    override suspend fun invoke(input: WithdrawRequestUseCase.Input): UseCaseResult<Boolean> {
        return raiseRequest(input)
    }

    private suspend fun raiseRequest(input: WithdrawRequestUseCase.Input): UseCaseResult<Boolean> {
        val result = getResult<BaseResponse<Boolean?>> {
            repo.postWithdrawRequest(WithdrawRequestModel(requestId = input.requestId))
        }
        if (result.isSuccess) {
            return UseCaseResult.success(true)
        }
        return UseCaseResult.failure(result.getErrorData()!!)
    }
}