package com.shipsy.ondemand.riderapp.domain.usecase.transactionhistory

import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.core.framework.network.getResult
import com.shipsy.ondemand.riderapp.framework.network.model.BaseResponse
import com.shipsy.ondemand.riderapp.framework.network.model.transactionhistory.TransactionRecord
import com.shipsy.ondemand.riderapp.framework.network.model.transactionhistory.TransactionData
import com.shipsy.ondemand.riderapp.framework.network.model.transactionhistory.TransactionHistoryRequestBody
import com.shipsy.ondemand.riderapp.interactor.repository.HistoryRepository
import com.shipsy.ondemand.riderapp.interactor.usecase.transactionhistory.FetchRejectedRequestsUseCase

/**
 * Created by Kalpesh Kundanani on 12/10/22
 */
class FetchRejectedRequestsUseCaseImpl(
    private val repo: HistoryRepository
) : FetchRejectedRequestsUseCase {
    override suspend fun invoke(input: FetchRejectedRequestsUseCase.Input): UseCaseResult<List<TransactionRecord>> {
        return getData(input)
    }

    private suspend fun getData(input: FetchRejectedRequestsUseCase.Input): UseCaseResult<List<TransactionRecord>> {
        val body =
            TransactionHistoryRequestBody(input.fromDate, input.toDate, input.selectedHubList)

        val result = getResult<BaseResponse<TransactionData>> { repo.fetchRejectedRequests(body) }
        if (result.isSuccess) {
            val response = result.getOrNull()
            return UseCaseResult.success(response!!.data!!)
        }

        return UseCaseResult.failure(result.getErrorData()!!)
    }
}