package com.shipsy.ondemand.riderapp.domain.usecase.statusupdate

import com.shipsy.ondemand.core.framework.datetime.DateTime
import com.shipsy.ondemand.core.framework.network.DisplayType
import com.shipsy.ondemand.core.framework.network.ErrorData
import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.core.framework.network.getResult
import com.shipsy.ondemand.riderapp.framework.network.model.BaseResponse
import com.shipsy.ondemand.riderapp.interactor.repository.StatusUpdateRepository
import com.shipsy.ondemand.riderapp.interactor.usecase.statusupdate.CallReasonStatusUpdateUseCase
import com.shipsy.ondemand.riderapp.models.CallLogs
import com.shipsy.ondemand.riderapp.models.CallStatusRequest
import com.shipsy.ondemand.riderapp.models.CallStatusUpdateResponse

/**
 * Created by Kalpesh Kundanani on 24/01/23
 */
class CallReasonStatusUpdateUseCaseImpl(
    private val repo: StatusUpdateRepository
) : CallReasonStatusUpdateUseCase {
    override suspend fun invoke(input: CallReasonStatusUpdateUseCase.Input): UseCaseResult<Boolean> {

        val response =
            getResult<BaseResponse<CallStatusUpdateResponse>> { repo.updateCallReasonSelection(
                CallStatusRequest(
                    arrayListOf(
                        CallLogs(
                            reference_number = input.reference_number,
                            status = input.status,
                            message = input.message,
                            event_time = DateTime.currentTimeMillis()
                        )
                    )
                )
            ) }

        if (response.isSuccess) {
            val isSuccess = response.getOrNull()?.data?.success ?: true
            return if (isSuccess)
                UseCaseResult.success(true)
            else
                UseCaseResult.failure(
                    ErrorData.GeneralError(
                        displayType = DisplayType.SnackBar(response.getOrNull()?.data?.failures?.firstOrNull()?.message ?: "Error updating status")
                    )
                )
        }

        return UseCaseResult.failure(response.getErrorData()!!)
    }
}