package com.shipsy.ondemand.riderapp.domain.usecase.statemanagement

import com.shipsy.ondemand.riderapp.cache.Database
import com.shipsy.ondemand.riderapp.domain.const.OrderStatusType
import com.shipsy.ondemand.riderapp.framework.data.WorkerStatus
import com.shipsy.ondemand.riderapp.interactor.usecase.statemanagement.OrderListUseCase
import com.shipsy.ondemand.riderapp.shared.cache.CurrentOrders

class OrderListUseCaseImpl(private val database: Database) :
    OrderListUseCase {
    override suspend fun invoke(input: OrderListUseCase.Input): OrderListUseCase.Output {
        return OrderListUseCase.Output(findOrders(findOrderStatusToProvide(input.workerStatus)))
    }

    private suspend fun findOrders(orderStatus: List<String>): List<CurrentOrders> {
        return database.currentOrdersDao.getOrdersByStatus(orderStatus) ?: listOf()
    }

    private fun findOrderStatusToProvide(workerStatus: WorkerStatus): List<String> {
       return when (workerStatus) {
            WorkerStatus.InStore -> listOf(OrderStatusType.ASSIGNED_FOR_DELIVERY,OrderStatusType.PICKUP_PROCESS_STARTED)
            WorkerStatus.OutForDeliver -> listOf(
                OrderStatusType.ASSIGNED_FOR_DELIVERY,
                OrderStatusType.PICKUP_COMPLETED,
                OrderStatusType.START_BIKE,
                OrderStatusType.REACHED_GATE,
                OrderStatusType.RTO_REACHED_GATE,
                OrderStatusType.PICKUP_PROCESS_STARTED,
                OrderStatusType.PICKED_UP
            )
            WorkerStatus.ReturningToStore -> listOf(
                OrderStatusType.DELIVERED,
                OrderStatusType.ATTEMPTED
            )
        }
    }
}