package com.shipsy.ondemand.riderapp.domain.usecase.statemanagement

import com.shipsy.ondemand.riderapp.cache.Database
import com.shipsy.ondemand.riderapp.interactor.usecase.statemanagement.FetchOrderDetailUseCase

class FetchOrderDetailUseCaseImpl(private val database: Database) : FetchOrderDetailUseCase {
    override suspend fun invoke(input: String): FetchOrderDetailUseCase.Output {
        return FetchOrderDetailUseCase.Output(
            database.currentOrdersDao.getOrdersByReferenceNumber(
                input
            )?.status
        )

    }
}