package com.shipsy.ondemand.riderapp.domain.usecase.sdk

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.*
import com.shipsy.ondemand.riderapp.framework.main.settings.FirebaseSettingHelper
import com.shipsy.ondemand.core.framework.network.DisplayType
import com.shipsy.ondemand.core.framework.network.ErrorData
import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.riderapp.interactor.usecase.sdk.FlushSdkRiderSavedPrefUseCase

class FlushSdkRiderSavedPrefUseCaseImpl(
    private val localStore: LocalStore
) : FlushSdkRiderSavedPrefUseCase {
    override fun invoke(): UseCaseResult<Boolean> {
        return try {
            flushSavedPrefs(localStore)
            UseCaseResult.success(true)
        } catch (e : Exception){
            e.printStackTrace()
            UseCaseResult.failure(
                error = ErrorData.GeneralError(
                    displayType = DisplayType.SnackBar(
                        error = e.message ?: "Error flushing saved preference"
                    )
                )
            )
        }
    }

    private fun flushSavedPrefs(localStore: LocalStore) {
        localStore.clear()
    }
}