package com.shipsy.ondemand.riderapp.domain.usecase.sdk

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.HUB_CODE
import com.shipsy.ondemand.riderapp.domain.const.worker_code
import com.shipsy.ondemand.riderapp.framework.data.sdk.SdkWorkerDetails
import com.shipsy.ondemand.core.framework.network.DisplayType
import com.shipsy.ondemand.core.framework.network.ErrorData
import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.riderapp.interactor.usecase.sdk.FetchSdkWorkerDetailsUseCase

/**
 * Created by Kalpesh Kundanani on 26/09/22
 */
class FetchSdkWorkerDetailsUseCaseImpl(
    private val localStore: LocalStore
) : FetchSdkWorkerDetailsUseCase {
    override fun invoke(): UseCaseResult<SdkWorkerDetails> {
        return fetchData()
    }

    private fun fetchData(): UseCaseResult<SdkWorkerDetails> {
        return try {
            val workerCode = localStore.getValue(worker_code, "")
            val hubCode = localStore.getValue(HUB_CODE, "")
            val data = SdkWorkerDetails(workerCode, hubCode)
            UseCaseResult.success(data)
        } catch (e: Exception) {
            UseCaseResult.failure(
                error = ErrorData.GeneralError(
                    displayType = DisplayType.SnackBar(
                        error = e.message ?: "Error fetching data!"
                    )
                )
            )
        }
    }

}