package com.shipsy.ondemand.riderapp.domain.usecase.sdk

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.PREF_SDK_FIREBASE_DATA_FIREBASE_API_KEY
import com.shipsy.ondemand.riderapp.domain.const.PREF_SDK_FIREBASE_DATA_FIREBASE_APPLICATION_ID
import com.shipsy.ondemand.riderapp.domain.const.PREF_SDK_FIREBASE_DATA_FIREBASE_DATABASE_URL
import com.shipsy.ondemand.riderapp.domain.const.PREF_SDK_FIREBASE_DATA_FIREBASE_PROJECT_ID
import com.shipsy.ondemand.riderapp.framework.data.sdk.SdkFirebaseData
import com.shipsy.ondemand.core.framework.network.DisplayType
import com.shipsy.ondemand.core.framework.network.ErrorData
import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.riderapp.interactor.usecase.sdk.FetchSdkFirebaseDataUseCase

/**
 * Created by Kalpesh Kundanani on 26/09/22
 */
class FetchSdkFirebaseDataUseCaseImpl(
    private val localStore: LocalStore
) : FetchSdkFirebaseDataUseCase {
    override fun invoke(): UseCaseResult<SdkFirebaseData> {
        return fetchData()
    }

    private fun fetchData(): UseCaseResult<SdkFirebaseData> {
        return try {
            val applicationID =
                localStore.getValue(PREF_SDK_FIREBASE_DATA_FIREBASE_APPLICATION_ID, "")
            val databaseURL =
                localStore.getValue(PREF_SDK_FIREBASE_DATA_FIREBASE_DATABASE_URL, "")
            val apiKey = localStore.getValue(PREF_SDK_FIREBASE_DATA_FIREBASE_API_KEY, "")
            val projectID =
                localStore.getValue(PREF_SDK_FIREBASE_DATA_FIREBASE_PROJECT_ID, "")

            val data = SdkFirebaseData(applicationID, databaseURL, apiKey, projectID)
            UseCaseResult.success(data)
        } catch (e: Exception) {
            UseCaseResult.failure(
                error = ErrorData.GeneralError(
                    displayType = DisplayType.SnackBar(
                        error = e.message ?: "Error fetching data!"
                    )
                )
            )
        }
    }
}