package com.shipsy.ondemand.riderapp.domain.usecase.sdk

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.*
import com.shipsy.ondemand.riderapp.framework.data.sdk.SdkAppSettings
import com.shipsy.ondemand.riderapp.interactor.usecase.sdk.FetchSdkAppSettingsUseCase

/**
 * Created by Kalpesh Kundanani on 26/09/22
 */
class FetchSdkAppSettingsUseCaseImpl(
    private val localStore: LocalStore
) : FetchSdkAppSettingsUseCase {
    override fun invoke(): SdkAppSettings {
        return fetchData()
    }

    private fun fetchData(): SdkAppSettings {

        val sdkHealthCheckAPIInterval =
            localStore.getValue(PREF_SDK_APP_SETTINGS_SDK_HEALTH_CHECK_API_INTERVAL, DEFAULT_SDK_HEALTH_CHECK_API_INTERVAL)
        val updateFirebaseCoordinates =
            localStore.getValue(PREF_SDK_APP_SETTINGS_UPDATE_FIREBASE_COORDINATES, false)
        val firebasePingInterval =
            localStore.getValue(PREF_SDK_APP_SETTINGS_FIREBASE_PING_INTERVAL, DEFAULT_FIREBASE_PING_INTERVAL)
        val mixpanelProjectToken =
            localStore.getValue(PREF_SDK_MIXPANEL_PROJECT_TOKEN, "")

        return SdkAppSettings(
            sdkHealthCheckAPIInterval,
            updateFirebaseCoordinates,
            firebasePingInterval,
            mixpanelProjectToken
        )
    }
}