package com.shipsy.ondemand.riderapp.domain.usecase.riderstate

import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.cache.Database
import com.shipsy.ondemand.riderapp.framework.network.model.login.RiderStateResponse
import com.shipsy.ondemand.riderapp.interactor.usecase.riderstate.FetchRiderStateUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.riderstate.PostRiderStateUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.riderstate.RiderStateHandlerUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.riderstate.ShouldFetchRiderStateUseCase

class RiderStateHandlerUseCaseImpl(
    private val localStore: LocalStore,
    private val fetchRiderStateUseCase: FetchRiderStateUseCase,
    private val postRiderStateUseCase: PostRiderStateUseCase,
    private val shouldFetchRiderStateUseCase: ShouldFetchRiderStateUseCase,
    private val database: Database
) : RiderStateHandlerUseCase {
    override suspend fun invoke(): UseCaseResult<RiderStateResponse> {
        println("calling api")

        return  if (shouldFetchRiderStateUseCase.invoke()) {
            fetchRiderStateUseCase.invoke()
        } else {
            postRiderStateUseCase.invoke(database.riderStateEventDao.getRiderStateEventDataItems())
        }
    }
}