package com.shipsy.ondemand.riderapp.domain.usecase.riderstate

import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.core.framework.network.getResult
import com.shipsy.ondemand.riderapp.framework.network.model.login.RiderStateResponse
import com.shipsy.ondemand.riderapp.framework.network.model.riderevent.RiderEvent
import com.shipsy.ondemand.riderapp.framework.network.model.riderevent.RiderStateRequest
import com.shipsy.ondemand.riderapp.interactor.repository.PostRiderEventRepository
import com.shipsy.ondemand.riderapp.interactor.usecase.UpdateRiderStateUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.riderstate.PostRiderStateUseCase

class PostRiderStateUseCaseImpl(
    private val postRiderEventRepository: PostRiderEventRepository,
    private val updateRiderStateUseCase: UpdateRiderStateUseCase
) : PostRiderStateUseCase {
    override suspend fun invoke(input: List<RiderEvent>): UseCaseResult<RiderStateResponse> {
        val request = RiderStateRequest(false, input)
        val response : UseCaseResult<RiderStateResponse> = getResult { postRiderEventRepository.postRiderStateEvents(request) }
        if(response.isSuccess){
            updateRiderStateUseCase.invoke(response.getOrNull())
            println("api update done $response $input")
        }
        return response
    }
}