package com.shipsy.ondemand.riderapp.domain.usecase.riderstate

import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.core.framework.network.getResult
import com.shipsy.ondemand.riderapp.framework.network.model.login.RiderStateResponse
import com.shipsy.ondemand.riderapp.interactor.repository.FetchRiderStateRepository
import com.shipsy.ondemand.riderapp.interactor.usecase.UpdateRiderStateUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.riderstate.FetchRiderStateUseCase

class FetchRiderStateUseCaseImpl(
    private val fetchRiderStateRepository: FetchRiderStateRepository,
    private val updateRiderStateUseCase: UpdateRiderStateUseCase
) : FetchRiderStateUseCase {
    override suspend fun invoke(): UseCaseResult<RiderStateResponse> {
        val response: UseCaseResult<RiderStateResponse> =
            getResult { fetchRiderStateRepository.getRiderState() }

        if (response.isSuccess) {
            updateRiderStateUseCase.invoke(response.getOrNull())
        }

        return response
    }
}