package com.shipsy.ondemand.riderapp.domain.usecase.riderstate

import com.shipsy.ondemand.riderapp.cache.Database
import com.shipsy.ondemand.riderapp.domain.const.SyncType
import com.shipsy.ondemand.riderapp.firebase.FirebaseEventHandler
import com.shipsy.ondemand.core.framework.network.DisplayType
import com.shipsy.ondemand.core.framework.network.ErrorData
import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.riderapp.framework.network.model.login.RiderStateResponse
import com.shipsy.ondemand.riderapp.framework.network.model.riderevent.RiderEvent
import com.shipsy.ondemand.riderapp.interactor.usecase.riderstate.EventSyncUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.riderstate.LocalEventHandlingUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.riderstate.PostRiderStateUseCase

class EventSyncUseCaseImpl(
    private val postRiderStateUseCase: PostRiderStateUseCase,
    private val database: Database,
    private val localEventHandlingUseCase: LocalEventHandlingUseCase
) : EventSyncUseCase {
    override suspend fun invoke(input: EventSyncUseCase.Input): UseCaseResult<RiderStateResponse> {
        input.riderEvent?.let { FirebaseEventHandler.logButtonSwipeEvent(it.type, it.auto_swipe) }
        return when (input.syncType) {
            SyncType.Post -> {
                val eventList = arrayListOf<RiderEvent>()
                eventList.addAll(database.riderStateEventDao.getRiderStateEventDataItems())
                input.riderEvent?.let { eventList.add(it) }
                postRiderStateUseCase.invoke(eventList)
            }
            SyncType.Sync -> {
                if (input.riderEvent == null) {
                    return UseCaseResult.failure(
                        ErrorData.GeneralError(
                            true,
                            DisplayType.SnackBar("Sync type can't have empty event")
                        )
                    )
                }
                database.riderStateEventDao.insertRiderEvent(input.riderEvent)
                localEventHandlingUseCase.invoke(input.riderEvent)
            }
        }
    }
}