package com.shipsy.ondemand.riderapp.domain.usecase.riderstate

import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.core.framework.network.getResult
import com.shipsy.ondemand.riderapp.framework.network.model.BaseResponse
import com.shipsy.ondemand.riderapp.framework.network.model.checkout.CheckoutRequest
import com.shipsy.ondemand.riderapp.framework.network.model.login.RiderCurrentState
import com.shipsy.ondemand.riderapp.framework.network.model.login.RiderStateResponse
import com.shipsy.ondemand.riderapp.interactor.repository.CheckoutRepository
import com.shipsy.ondemand.riderapp.interactor.usecase.FetchSavedAdsIdUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.UpdateRiderStateUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.location.FetchSavedLocation
import com.shipsy.ondemand.riderapp.interactor.usecase.riderstate.CheckoutUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.worker.FetchWorkerIdUseCase

class CheckoutUseCaseImpl(
    private val fetchWorkerIdUseCase: FetchWorkerIdUseCase,
    private val fetchSavedLocation: FetchSavedLocation,
    private val checkoutRepository: CheckoutRepository,
    private val updateRiderStateUseCase: UpdateRiderStateUseCase,
    private val fetchSavedAdsIdUseCase: FetchSavedAdsIdUseCase
) : CheckoutUseCase {
    override suspend fun invoke(input: CheckoutUseCase.Input): UseCaseResult<Boolean> {
        val workerId = fetchWorkerIdUseCase.invoke()
        val location = fetchSavedLocation.invoke()
        val adsId = fetchSavedAdsIdUseCase.invoke()
        val checkoutRequest = CheckoutRequest(
            mobile_time = input.time,
            lat = location.lat,
            lng = location.lng,
            ads_id = adsId
        )
        val response = getResult<BaseResponse<Boolean>> {
            checkoutRepository.checkoutRider(
                workerId,
                checkoutRequest
            )
        }

        if (response.isFailure) {
            return UseCaseResult.failure(response.getErrorData()!!)
        }

        if (response.isSuccess) {
            updateRiderStateUseCase.invoke(
                RiderStateResponse(
                    current_state = RiderCurrentState(
                        checked_in = false,
                        current_orders = listOf(),
                        worker_status = null,
                        trip_reference_number= "",
                    )
                )
            )
        }

        return UseCaseResult.success(response.isSuccess)
    }
}