package com.shipsy.ondemand.riderapp.domain.usecase.pickupprocess

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.DEFAULT_SCAN_TIMER_DURATION
import com.shipsy.ondemand.riderapp.domain.const.PICKUP_CONFIG_SCAN_TIMER_DURATION
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.pickupscan.FetchPickupScanTimerDurationUseCase

/**
 * Created by Kalpesh Kundanani on 12/11/22
 */
class FetchPickupScanTimerDurationUseCaseImpl(
    private val localStore: LocalStore
) : FetchPickupScanTimerDurationUseCase {
    override fun invoke(): Int {
        return getDuration()
    }

    private fun getDuration(): Int {
        return localStore.getValue(
            PICKUP_CONFIG_SCAN_TIMER_DURATION,
            DEFAULT_SCAN_TIMER_DURATION
        )
    }
}