package com.shipsy.ondemand.riderapp.domain.usecase.pickupprocess

import com.shipsy.ondemand.riderapp.framework.data.PickupProcessScreen
import com.shipsy.ondemand.riderapp.framework.data.oderdata.OrderData
import com.shipsy.ondemand.core.framework.network.DisplayType
import com.shipsy.ondemand.core.framework.network.ErrorData
import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.riderapp.interactor.usecase.pickupprocess.FetchPickupProcessScreenToShow

/**
 * Created by Kalpesh Kundanani on 02/09/22
 */
class FetchPickupProcessScreenToShowImpl: FetchPickupProcessScreenToShow {
    override fun invoke(input: OrderData): UseCaseResult<PickupProcessScreen> {
        return getScreen(input)
    }

    private fun getScreen(order: OrderData): UseCaseResult<PickupProcessScreen> {
        return if (order.isAssignedForDelivery) {
            UseCaseResult.success(
                PickupProcessScreen.GoingForPickupScreen(referenceNumber = order.referenceNumber)
            )
        } else if (order.isPickupStarted) {
            UseCaseResult.success(
                PickupProcessScreen.CompletePickupScreen(referenceNumber = order.referenceNumber)
            )
        } else if(order.isPickupComplete) {
            UseCaseResult.success(
                PickupProcessScreen.ReachGateScreen(referenceNumber = order.referenceNumber)
            )
        } else {
            val snackBar = DisplayType.SnackBar("Unknown order status: " + order.status)
            val error = ErrorData.GeneralError(true, snackBar)
            UseCaseResult.failure(error = error)
        }
    }
}