package com.shipsy.ondemand.riderapp.domain.usecase.orderhistory

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_RIDER_APP_ICONS_CONFIG
import com.shipsy.ondemand.riderapp.framework.data.orderhistory.DeliveryStateData
import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.riderapp.interactor.usecase.orderhistory.FetchDeliveryEventStatesUseCase
import kotlinx.serialization.decodeFromString
import kotlinx.serialization.json.Json

/**
 * Created by Kalpesh Kundanani on 28/08/22
 */
class FetchDeliveryEventStatesUseCaseImpl(
    val localStore: LocalStore
) : FetchDeliveryEventStatesUseCase {
    override fun invoke(): UseCaseResult<HashMap<String, DeliveryStateData>> {
        return try {
            val json = localStore.getValue(SHARED_PREF_RIDER_APP_ICONS_CONFIG, "")
            val list = Json.decodeFromString<HashMap<String, DeliveryStateData>>(json)
            UseCaseResult.success(list)
        } catch (e: Exception) {
            UseCaseResult.success(hashMapOf())
        }
    }
}