package com.shipsy.ondemand.riderapp.domain.usecase.orderdetail

import com.shipsy.ondemand.riderapp.cache.Database
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.IsPudoFlowEnabledUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.orderdetail.RemoveOrderUseCase

/**
 * Created by Kalpesh Kundanani on 14/02/23
 */
class RemoveOrderUseCaseImpl(
    private val database: Database,
    private val isPudoFlowEnabledUseCase: IsPudoFlowEnabledUseCase
): RemoveOrderUseCase {
    override suspend fun invoke(input: RemoveOrderUseCase.Input) {
        val isPudo = isPudoFlowEnabledUseCase.invoke()
        if (isPudo) {
            database.currentOrdersDao.deleteOrderByOrderNumber(input.id)
        } else {
            database.currentOrdersDao.deleteOrderByReferenceNumber(input.id)
        }
    }
}