package com.shipsy.ondemand.riderapp.domain.usecase.orderdetail

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.getReachedGateKey
import com.shipsy.ondemand.riderapp.interactor.usecase.orderdetail.RecordReachGateTimeUseCase

/**
 * Created by Kalpesh Kundanani on 07/12/22
 */
class RecordReachGateTimeUseCaseImpl(
    val localStore: LocalStore
): RecordReachGateTimeUseCase {
    override fun invoke(input: RecordReachGateTimeUseCase.Input): Boolean {
        localStore.putValue(getReachedGateKey(input.referenceNumber), input.timestamp)
        return true
    }
}