package com.shipsy.ondemand.riderapp.domain.usecase.orderdetail

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.PREF_KEY_DELIVERED_TIME
import com.shipsy.ondemand.riderapp.interactor.usecase.orderdetail.RecordDeliveryTimeUseCase

/**
 * Created by Kalpesh Kundanani on 07/12/22
 */
class RecordDeliveryTimeUseCaseImpl(
    val localStore: LocalStore
): RecordDeliveryTimeUseCase {
    override fun invoke(input: RecordDeliveryTimeUseCase.Input): Boolean {
        localStore.putValue(PREF_KEY_DELIVERED_TIME, input.timestamp)
        return true
    }
}