package com.shipsy.ondemand.riderapp.domain.usecase.orderdetail

import com.shipsy.ondemand.riderapp.cache.Database
import com.shipsy.ondemand.riderapp.cache.dao.mapToCurrentOrder
import com.shipsy.ondemand.riderapp.framework.data.oderdata.OrderData
import com.shipsy.ondemand.riderapp.interactor.usecase.orderdetail.OrdersFetchUseCase

class OrdersFetchUseCaseImpl(val database: Database) : OrdersFetchUseCase {
    override suspend fun invoke(): List<OrderData> {
        return getOrders()
    }

    private suspend fun getOrders(): List<OrderData> {
        val currentOrders = database.currentOrdersDao.getCurrentOrders()
        return currentOrders.map {
            val currentOrder = it.mapToCurrentOrder()
            OrderData.fromCurrentOrder(currentOrder)
        }
    }

}